# -*- coding: utf-8 -*-
import ctypes
import keyboardHandler
import queueHandler
import review
from time import sleep
import windowUtils
import gettext
import controlTypes
import  addonHandler
import winsound
import globalVars
import keyboardHandler
import languageHandler
import speech
import displayModel
import wx
import os
import oleacc
import re
import NVDAObjects
from NVDAObjects.IAccessible import IAccessible
import api 
import winUser
import gui
import appModuleHandler
import textInfos
import ui
addonHandler.initTranslation()
_basePath = os.path.dirname(os.path.abspath(__file__))

def isDescendantWindow (obj, control):
		# retorna o identificador de um objeto filho  a partir de um objeto pai.
	try:
		h=obj.windowHandle
		j=windowUtils.findDescendantWindow(h,controlID=control)
		if winUser.isWindowEnabled(j) and winUser.isWindowVisible(j):
			return j
		return 0
	except:
		return 0

def clickButton (location):
		# efetua um clique esquerdo num objeto a partir de suas coordenadas passadas.
	(left, top, width, height) = (int(location[0]), int(location[1]), int(location[2]), int (location[3]))
	if (left+top+width+height)>0:
		x, y = 0, 0
		x=left+(width)/2
		y=top+(height)/2
		winUser.setCursorPos (x,y)
		winUser.mouse_event(winUser.MOUSEEVENTF_LEFTDOWN,0,0,None,None)
		winUser.mouse_event (winUser.MOUSEEVENTF_LEFTUP,0,0,None,None)



class SmButtons(NVDAObjects.IAccessible.IAccessible):
		# overlay class referentes a alguns controles.
		# trata o acionamento de alguns botes, bem como a mudana de textos em alguns deles, em busca da mudana de pergunta e a resposta correta.

	def obterPergunta(self):
		#retorna a pergunta na janela principal.
		# do contedo de texto da tela, retira os nomes dos jogadores e as alternativas.
		# obtm as alternativas visveis na tela e monta uma string com os textos.
		alts=''
		for h in range(107,103,-1):
			h=isDescendantWindow(api.getForegroundObject(),h)
			if h:
				obj=NVDAObjects.IAccessible.getNVDAObjectFromEvent(h,-4,0)
				alts+=obj.displayText+'\n'
			# retira as alternativas.
			text=api.getForegroundObject().firstChild.displayText.split(alts)[0].strip()
			firstLine=text.split('\n')[0]
			# elimina a primeira linha, se esta contiver o nomes de jogadores e valores.
			pat=re.compile('\D+ - \d+|^\d+')
			if len (re.findall(pat,firstLine)):
				text= text.replace(firstLine,'')
			return text

	def startMonitoring(self):
		# inicia a procura por mudana de texto.
		self.answer=None

		if self.windowControlID in range(104,108)or self.windowControlID==17 or self.windowControlID==1 or self.windowControlID==2:
			displayModel.requestTextChangeNotifications(self, True)

	def stopMonitoring(self):
		# finaliza a busca por mudana de textos.
		displayModel.requestTextChangeNotifications(self, False)

	def verificaMudancas (self):
		#trata as mudanas de textos nos controles
		if self.windowControlID==1:
			#verifica a alterao de pergunta quando se pula uma questo, neste caso o evento foreground no  disparado.
			novaPergunta=self.obterPergunta()
			if AppModule(None).pergunta!=novaPergunta:
				# verifica se a reproduo de udio da pergunta est ativa, se sim, rerpproduz.
				if AppModule(None).audioPergunta:
					winsound.PlaySound('%s\\audios\\pergunta.wav' %_basePath,0)
				AppModule(None).pergunta=novaPergunta
				AppModule(None).obterJogador_valor()
				#foca e anuncia a primeira alternativa.
				h=isDescendantWindow(api.getForegroundObject(),107)
				obj=NVDAObjects.IAccessible.getNVDAObjectFromEvent(h,-4,0)
				api.setFocusObject(obj)
				obj.setFocus()
				ui.message('%s\n %s. %s' %(novaPergunta,1,obj.displayText))
				self.stopMonitoring()
		elif self.windowControlID==17:
			#obtendo a porcentagem das placas.
			speech.cancelSpeech()
			text=self.displayText
			if text!='':
				text=text[1:]
				l=text.split('%')
				if '' in l:
					l.remove('')
				results = map(int, l)
				results.sort()
				resposta=str(results.pop())
				# pega o ndice/nmero e o texto da resposta correta.
				index=l.index(resposta)+1
				h=isDescendantWindow(api.getForegroundObject(),108-index)
				alternativa=NVDAObjects.IAccessible.getNVDAObjectFromEvent(h,-4,0).displayText
				ui.message (_('%s porcento das placas sugerem como resposta certa a %s , %s') %(resposta,index,alternativa))
				self.stopMonitoring()
		elif self.windowControlID in range(104,108):
			# obter a resposta correta
			# a resposta correta fica piscando na tela gerando o evento de mudana de texto.

			if self.displayText!='' and self.answer is None:
				globalVars.smg6Valor = globalVars.smg6Valor * (globalVars.smg6Valor!=500000)
				msg=_('total ganho: %d reais') %(globalVars.smg6Valor /2)
				self.answer=(_('Resposta correta: %s. %s.') %(108-self.windowControlID,self.displayText))
				ui.message('%s\n%s' %(self.answer,msg))
				self.stopMonitoring



	def event_textChange(self):
		# Detecta a mudana de textos na tela e dispara a funo para tratamento das informaes.

		queueHandler.queueFunction(queueHandler.eventQueue, self.verificaMudancas)

	def script_mudarAlternativas(self,gesture):
		# tratamento das mudanas das alternativas com setas acima e abaixo.
		# alterna entre as alternativas disponveis.
		id=self.windowControlID
		if not id in range (104,108):
			gesture.send()
			return
		key=gesture.mainKeyName.lower()
		x=0
		while x<=4:
			if key=='downarrow':
				id=id-1+4*(id==104)
			else: # UpArrow.
				id=id+1-4*(id==107)
			h=isDescendantWindow(api.getForegroundObject(), id)
			if h!=0: # a alternativa est habilitada e visvel.
				obj=NVDAObjects.IAccessible.getNVDAObjectFromEvent(h,-4,0)
				api.setFocusObject(obj)
				obj.setFocus()
				api.setMouseObject(obj)
				api.moveMouseToNVDAObject(obj)
				o=oleacc.AccessibleObjectFromWindow(obj.windowHandle,-4)
				o.accselect(1,0)
				break
			x+=1
	# Documentation
	script_mudarAlternativas.__doc__ = _(u"Forca a mudanca entre as alternativas com as setas verticais")


	def script_enter(self,gesture):
		# processa o pressionamento da tecla enter.
		# verifica se alguns botes de confirmao de resposta certa e de parar esto visveis, caso afirmativo, os aciona.
		obj=self
		yesAnswerConfirmation=isDescendantWindow(api.getForegroundObject(), 101)
		yesStopConfirmation=isDescendantWindow(api.getForegroundObject(), 27)
		jumpVideo=isDescendantWindow(api.getForegroundObject(), 2)
		if jumpVideo!=0:
			# o boto pular vdio est visvel.
			obj = NVDAObjects.IAccessible.getNVDAObjectFromEvent(jumpVideo,-4,0)
		elif yesAnswerConfirmation!=0:
			# o boto dsim para confirmar a resposta correta est visvel
			obj = NVDAObjects.IAccessible.getNVDAObjectFromEvent(yesAnswerConfirmation,-4,0)
			clickButton (obj.location)
			alternativesList=range(104,108)
			# remove a alternativa escolhida para iniciar a varredura em busca da resposta correta que piscar na tela.
			alternativesList.remove(self.chosenAlternative)
			for control in alternativesList:
				h=isDescendantWindow(api.getForegroundObject(),control)
				alt=NVDAObjects.IAccessible.getNVDAObjectFromEvent(h,-4,0)
				alt.startMonitoring()
			return
		elif yesStopConfirmation!=0:
			# o boto sim para parar de jogar est visvel.
			obj = NVDAObjects.IAccessible.getNVDAObjectFromEvent(yesStopConfirmation,-4,0)
		elif self.windowControlID==11:
			# boto regras, exibe a caixa de dilogo com a respectiva informao.
			AppModule(None).showInfo(_('Regras'),_('Regras do jogo'))
			return
		elif self.windowControlID in range (104,108):
			#registra a alternativa escolhida como resposta.
			self.chosenAlternative=self.windowControlID
		clickButton (obj.location)
	# Documentation
	script_enter.__doc__ = _(u"Processa o pressionamento da tecla enter sobre as alternativas e alguns botoes de confirmacao")



	def script_escape(self,gesture):
		# aciona o boto no, referentes a confirmao da resposta e do desejo de parar.
		obj=self
		noAnswerConfirmation=isDescendantWindow(api.getForegroundObject(), 100)
		noStopConfirmation=isDescendantWindow(api.getForegroundObject(), 26)
		if noAnswerConfirmation+noStopConfirmation==0:
			gesture.send()
			return
		# registra em focus o objeto atual.
		focus=api.getFocusObject()
		if noAnswerConfirmation!=0:
			obj = NVDAObjects.IAccessible.getNVDAObjectFromEvent(noAnswerConfirmation,-4,0)
		elif noStopConfirmation!=0:
			obj = NVDAObjects.IAccessible.getNVDAObjectFromEvent(noStopConfirmation,-4,0)
		clickButton (obj.location)
		# restabelece o foco anterior.
		api.setFocusObject(focus)
		focus.setFocus()
	# Documentation
	script_escape.__doc__ = _(u"Cancela os questionamentos de confirmacao e parar")

	__gestures = {
		"kb:upArrow": "mudarAlternativas",
		"kb:downArrow": "mudarAlternativas",
		"kb:enter": "enter",
		"kb:escape": "escape",
		}

class AppModule(appModuleHandler.AppModule):

	def __init__(self, *args, **kwargs):
		super(AppModule, self).__init__(*args, **kwargs)
		globalVars.smg6Valor =0
		self.smg6start = False
		self.audioPergunta=True
		self.pergunta=''
		self.valor = '0'
		self._materias={}
		globalVars.smg6_mainWindow=api.getForegroundObject()
		self._checklist=None
		self._infoDialog=None
		self.player=''
		self.placar=None
		self.palavraPergunta=None
		self.palavraSoletra=None
	def __del__(self):
		if self._checklist is not None:
			self._checklist.Destroy()
		#if self._infoDialog is not None:
			#self._infoDialog.Destroy()

	def event_NVDAObject_init(self,obj):
		buttonsMenu={8:_('Jogar'),9:_('Jogar Online'),10:_('Placar'),11:_('Regras'),12:_('Sair')}
		for x in range (8,13):
			try:
				if obj.windowControlID == x:
					obj.name = buttonsMenu[x]
					obj.role = controlTypes.ROLE_BUTTON
			except:
				pass
		for id   in range (26, 34):
			try:
				if isinstance(obj, NVDAObjects.IAccessible.IAccessible) and obj.windowControlID == id and obj.role == controlTypes.ROLE_EDITABLETEXT:
					obj.name = _('Participante %s') %(34-id)
			except:
				pass
	def chooseNVDAObjectOverlayClasses(self, obj, clsList):
		if isinstance(obj, NVDAObjects.IAccessible.IAccessible) and  winUser.getControlID(obj.windowHandle) in [1,2,3,8,10,11,12,17,26, 27,100,101,104,105,106,107] and obj.role != controlTypes.ROLE_EDITABLETEXT :
			clsList.insert(0, SmButtons)


	def showInfo(self, file, title):
			# exibe as caixas de dilogos de informaes de atalhos e regras.
			file='%s\\textos\\%s.txt' %(_basePath,file)
			if not os.path.isfile(file):
				ui.message (_('Arquivo de %s nao encontrado') %(file))
				return
			content = open (file).read()
			if self._infoDialog is None:
				self._infoDialog= infoDialog(gui.mainFrame, title, content)
			if not self._infoDialog.IsShown():
				gui.mainFrame.prePopup()
				self._infoDialog.Show()
				self._infoDialog.Centre()
				gui.mainFrame.postPopup()

	def resetaVar (self):
		# reseta variveis.
		self.pergunta=''
		self.valor='0'
		self.palavraPergunta=None
		self.palavraSoletra=None
		self.player=''


	def event_foreground (self, obj, nextHandler):
		if isDescendantWindow (obj,2):
			# est na janela do vdeo de abertura ou na janela anterior a tela das perguntas.
			# coloca o controle de pular o vdo em foco.
			if self.pergunta=='':
				speech.speechMode=0
				keyboardHandler.KeyboardInputGesture.fromName('tab').send()
				speech.speechMode=2
			self.resetaVar()
		elif isDescendantWindow (obj, 9):
			self.resetaVar()
		elif self.isDescendantWindow (obj,107) and self.pergunta=='':
			# est na janela principal de perguntas.
			if self.audioPergunta:
				# se configurado para sim, reproduz um udio antes do anncio da pergunta.
				winsound.PlaySound('%s\\audios\\pergunta.wav' %_basePath,0)
			self.obterJogador_valor()
			speech.speechMode=0
			keyboardHandler.KeyboardInputGesture.fromName('tab').send()
			speech.speechMode=2

		nextHandler()
	def script_pergunta(self,gesture):
		#informa a pergunta atual.
		if isDescendantWindow(api.getForegroundObject(),103):
			#self.obterJogador_valor()
			self.pergunta=api.getForegroundObject().firstChild.obterPergunta()
			ui.message(self.pergunta)
			# se nenhuma alternativa estiver selecionada, focaliza a primeira.
			if not api.getFocusObject().windowControlID in range(104,108):
				h=isDescendantWindow(api.getForegroundObject(),107)
				if h:
					obj=NVDAObjects.IAccessible.getNVDAObjectFromEvent(h,-4,0)
					obj.name='1. %s' %obj.displayText
					api.setFocusObject(obj)
					obj.setFocus()
					speech.speakObjectProperties(obj,name=True,role=False)
	# Documentation
	script_pergunta.__doc__ = _(u"Anuncia a pergunta atual na janela principal")

	def script_placas(self,gesture):
		# aciona o boto para pedir ajuda das placas.

		if not isDescendantWindow(api.getForegroundObject(),103): # no est na janela de perguntas e respostas.
			gesture.send()
			return
		hPlacas=isDescendantWindow(api.getForegroundObject(),85)
		if hPlacas==0:
			ui.message (_('sem a ajuda de placas'))
			return
		objPlacas=NVDAObjects.IAccessible.getNVDAObjectFromEvent(hPlacas,-4,0)
		hRespostaPlacas=self.isDescendantWindow(api.getForegroundObject(),17)
		if hRespostaPlacas!=0:
			objRespostaPlacas=NVDAObjects.IAccessible.getNVDAObjectFromEvent(hRespostaPlacas,-4,0)
			# inicia a varredura em busca da resposta das placas na tela.
			objRespostaPlacas.startMonitoring()
		# focus  o objeto em foco antes de acionar o boto placas.
		focus=api.getFocusObject()
		# aciona o boto placas.
		clickButton(objPlacas.location)
		sleep(0.5)
		api.setFocusObject(focus)
		focus.setFocus()
		speech.cancelSpeech()
	# Documentation
	script_placas.__doc__ = _(u"Anuncia o resultado da ajuda das placas")


	def script_universitarios(self,gesture):
		# aciona o boto de pedido de ajuda aos convidados/universitrios e informa o resultado da consulta.

		if not isDescendantWindow(api.getForegroundObject(),103): # est fora da janela de perguntas e respostas.
			gesture.send()
			return
		hUniversitarios=isDescendantWindow(api.getForegroundObject(),70)
		if hUniversitarios==0:
			ui.message (_('sem a ajuda dos universitarios'))
			return
		objUniversitarios=NVDAObjects.IAccessible.getNVDAObjectFromEvent(hUniversitarios,-4,0)
		hRespostaUniversitarios=self.isDescendantWindow(api.getForegroundObject(),20)
		if hRespostaUniversitarios!=0:
			objRespostaUniversitarios=NVDAObjects.IAccessible.getNVDAObjectFromEvent(hRespostaUniversitarios,-4,0)
		focus=api.getFocusObject()
		clickButton(objUniversitarios.location)
		sleep(0.3)
		text=objRespostaUniversitarios.displayText
		if text!='':
			index=int(text[-1])
		hResposta=isDescendantWindow(api.getForegroundObject(),108-index)
		alternative=NVDAObjects.IAccessible.getNVDAObjectFromEvent(hResposta,-4,0).displayText
		ui.message (_('A maioria dos universitarios escolheu a alternativa %s, %s') %(index,alternative))
		api.setFocusObject(focus)
		focus.setFocus()
	# Documentation
	script_universitarios.__doc__ = _(u"Anuncia o resultado da ajuda dos universitarios")


	def script_cartas(self,gesture):
		# clica na primeira de 3 cartas e informa o resultado obtido.
		if not isDescendantWindow(api.getForegroundObject(),103): # fora da janela de pergunta e respostas.
			gesture.send()
			return
		hCartas=isDescendantWindow(api.getForegroundObject(),82)
		if hCartas==0:
			ui.message (_('sem a ajuda das cartas'))
			return
		objCartas=NVDAObjects.IAccessible.getNVDAObjectFromEvent(hCartas,-4,0)
		focus=api.getFocusObject()
		clickButton(objCartas.location)
		sleep(0.4)
		hCarta1=self.isDescendantWindow(api.getForegroundObject(),15)
		if hCarta1!=0:
			objCarta1=NVDAObjects.IAccessible.getNVDAObjectFromEvent(hCarta1,-4,0)
			clickButton(objCarta1.location)
		sleep(0.4)
		cartaRetirada=''
		nCarta=4
		hRestante=0
		for controle in [107,106,105,104]:
			hAlt=self.isDescendantWindow(api.getForegroundObject(),controle)
			if hAlt!=0:
				nCarta-=1
				if nCarta==3:
					hRestante=hAlt

		if hRestante!=0:
			focus=NVDAObjects.IAccessible.getNVDAObjectFromEvent(hRestante,-4,0)
		speech.speechMode=0
		api.setFocusObject(focus)
		focus.setFocus()
		speech.speechMode=2
		speech.cancelSpeech()
		if nCarta in [0,1]:
			cartaRetirada=[_('rei, que pena!'),_('as')][nCarta]
		else:
			cartaRetirada=str(nCarta)
		ui.message (_('tirou um:\n %s.') %cartaRetirada)
		if nCarta==3:
			ui.message('%s. %s' %(108-hRestante, focus.displayText))
	# Documentation
	script_cartas.__doc__ = _(u"aciona e anuncia o resultado da ajuda das cartas")


	def script_pular(self, gesture):
		# aciona os pulos disponveis.
		if not isDescendantWindow(api.getForegroundObject(),103):
			gesture.send()
			return
		pulos=[]
		for controle in [79,76,73]:
			hPulo=self.isDescendantWindow(api.getForegroundObject(), controle)
			if hPulo!=0:
				pulos.append(NVDAObjects.IAccessible.getNVDAObjectFromEvent(hPulo,-4,0))
		if len(pulos)==0:
			ui.message(_('sem pulos'))
			return
		h=isDescendantWindow(api.getForegroundObject(),1)
		if h:
			obj=NVDAObjects.IAccessible.getNVDAObjectFromEvent(h,-4,0)
		focus=api.getFocusObject()
		api.getForegroundObject().firstChild.startMonitoring()
		clickButton(pulos[0].location)
		sleep(0.3)
		api.setFocusObject(focus)
		focus.setFocus()
	# Documentation
	script_pular.__doc__ = _(u"Aciona os pulos disponiveis")

	def script_parar(self,gesture):
		# aciona o boto parar.
		if not isDescendantWindow(api.getForegroundObject(),103): # est fora da janela de perguntas e respostas.
			gesture.send()
			return
		hParar=isDescendantWindow(api.getForegroundObject(),102)
		if hParar==0:
			ui.message (_('Sem parar'))
			return
		focus=api.getFocusObject()
		oParar=NVDAObjects.IAccessible.getNVDAObjectFromEvent(hParar,-4,0)
		clickButton(oParar.location)
		sleep(0.2)
		api.setFocusObject(focus)
		focus.setFocus()
		speech.cancelSpeech()
	# Documentation
	script_parar.__doc__ = _(u"Aciona o botao parar")


	def script_jogadorAtual(self,gesture):
		# anuncia o nome do jogador atual e o valor por ele obtido at o momento.
		if not isDescendantWindow(api.getForegroundObject(),103): # est fora da janela de perguntas e respostas.
			gesture.send()
			return
		if self.player!='':
			ui.message(_('%s com %s reais') %(self.player,self.valor))
		else:
			ui.message (_('erro ao obter o nome do jogador atual'))
	# Documentation
	script_jogadorAtual.__doc__ = _(u"Anuncia o jogador atual e o valor obtido ate o momento")


	def script_palavraPergunta(self,gesture):
		# anuncia a pergunta palavra por palavra.
		if self.palavraSoletra is None or self.pergunta =='':
			return
		l=self.pergunta.strip().split(' ')
		total=len(l)
		if not self.palavraSoletra in l:
			index=-1
		else:
			index=l.index(self.palavraSoletra)
		index=index+1-total*(index==total-1)
		ui.message(l[index])
		self.palavraSoletra=l[index]
	# Documentation
	script_palavraPergunta.__doc__ = _(u"Anuncia a pergunta atual palavra por palavra")

	def script_soletra(self, gesture):
		# soletra a palavra selecionada com f3 ou a ltima alternativa  selecionada com as setas.
		if self.palavraSoletra is not None:
			speech.speakSpelling(self.palavraSoletra.lower())
	# Documentation
	script_soletra.__doc__ = _(u"soletra a palavra selecionada na pergunta ou a alternativa atual")


	def script_audioPergunta(self,gesture):
		# alterna  entre reproduzir ou no o adio antes de cada pergunta.
			self.audioPergunta= not self.audioPergunta
			ui.message([_('som antes da pergunta desativado'),_('Som antes da pergunta ativado')][self.audioPergunta])
	# Documentation
	script_audioPergunta.__doc__ = _(u"Habilita ou nao a reproducao de um alerta antes da pergunta")


	def script_atalhos(self,gesture):
		# exibe a caixa de dilogo com os atalhos disponveis para o jogo.
		self.showInfo(_('atalhos'), _('Atalhos disponiveis para o jogo'))
	# Documentation
	script_atalhos.__doc__ = _(u"Exibe uma caixa de dialogo com os atalhos disponiveis para o jogo")


	def script_ajuda(self,gesture):
		# d informaes sobre a janela atual.
		# se estiver na janela de perguntas e respostas, anuncia as ajudas disponveis.
		texto=''
		if isDescendantWindow(api.getForegroundObject(),8):
			texto=_('Tela do menu inicial.\nPressione tab e shift+tab para navegar entre as opssoes e enter para ativar.')
		elif isDescendantWindow(api.getForegroundObject(),33):
			texto=_('Tela de cadastro dos jogadores.\nEntre com pelo menos um participante e pressione control +enter para escolher uma ou mais disciplinas')
		elif  isDescendantWindow(api.getForegroundObject(),103):
			ui.message (_('Tela principal de perguntas e alternativas.'))
			ajudas={70:'universitarios',82:'cartas',85:'placas',79:'pulo1',76:'pulo 2',73:'pulo 3'}
			texto=_('sem ajuda')
			for key in [85,70,82,79,76,73]:
				if isDescendantWindow(api.getForegroundObject(),key):
					if not ';'  in texto:
						texto= _('ajudas disponiveis:\n')
					texto=texto+'%s; ' %(ajudas[key])
		elif isDescendantWindow(api.getForegroundObject(),2) and api.getForegroundObject().firstChild.displayText=='':
			texto=_('Tela do video de abertura, pressione enter sobre o botao pular video')
		else:
			texto=_('Tela de transicao, aguarde.')

		ui.message(texto)
	# Documentation
	script_ajuda.__doc__ = _(u"Fornece uma ajuda para a tela atual")


	def script_tab (self,gesture):
		# fora o foco em alguns controles da janela do menu inicial,  de cadastro de participantes e perguntas e respostas.
		# alterna entre as caixas de texto de participantes, controles definidos para a tela do menu inicial e as alternativas.
		obj=api.getFocusObject()
		controls=[]
		key=("+".join(gesture.modifierNames)+"+"+gesture.mainKeyName).lower()
		menu=[8,10,11,12]
		editableTexts = range(33,25,-1)
		controlID=obj.windowControlID
		if isDescendantWindow(api.getForegroundObject(),103) :
			# est na janela de perguntas e respostas.
			# se o foco no estiver em nenhuma das alternativas, seleciona a primeira disponvel.
			l=range(107,103,-1)
			if not controlID in l:
				for alt in l:
					if isDescendantWindow(api.getForegroundObject(),alt):
						focus=NVDAObjects.IAccessible.getNVDAObjectFromEvent(isDescendantWindow(api.getForegroundObject(),alt),-4,0)
						api.setFocusObject(focus)
						focus.setFocus()
						focus.name='%s. %s' %(108-alt,focus.displayText)
						speech.speakObjectProperties (focus, name=True, role=False)
			return
		elif controlID in menu:
			# est na tela do menu inicial.
			controls=menu
		elif controlID in editableTexts and obj.role==controlTypes.ROLE_EDITABLETEXT:
			# est na janela de cadastro dos jogadores.
			controls=editableTexts
		else:
			gesture.send()
			return
		# inicia a alternncia entre os controles definidos.
		total=len(controls)
		index=controls.index(controlID)
		if key!= 'shift+tab':
			index=index+1-total*(index==total-1)
		else:
			index=index-1+total*(index==0)
		newControlID=controls[index]
		h=isDescendantWindow(api.getForegroundObject(),newControlID)
		obj=NVDAObjects.IAccessible.getNVDAObjectFromEvent(h,-4,0)
		o=oleacc.AccessibleObjectFromWindow(h,-4)
		o.accselect(1,0)
		api.setFocusObject(obj)
		obj.setFocus()
		api.setMouseObject(obj)
		api.moveMouseToNVDAObject(obj)
	# Documentation
	script_tab.__doc__ = _(u"Forca o foco em controles pre definidos numa janela")

	def script_sayWindowTitle(self, gesture):
		ui.message (_('Show do milho grande 6'))
	def event_appModule_loseFocus(self):
			self.smg6start = False

	def event_gainFocus(self, obj, nextHandler):
		globalVars.smg6_mainWindow=obj
		if (obj.windowClassName == 'ThunderRT5Form' or obj.windowClassName == 'ThunderRT5Main') and self.smg6start == False:
			ui.message (_('Show do milho grande 6'))
			self.smg6start = True
		if obj.role==controlTypes.ROLE_PANE or (obj.windowControlID in [20,25,26,27,82,85,17,100,101] and obj.role!=controlTypes.ROLE_EDITABLETEXT):
			# ignora o foco em alguns controles e faz o tratamento do foco no painel principal.
			h=isDescendantWindow(api.getForegroundObject(),8+2*(self.placar is not None))
			hVoltarPlacar=isDescendantWindow(api.getForegroundObject(),3)
			if h:
				# tela do menu inicial, foca o boto jogar ou o boto placar.
				ui.message ([_('Menu inicial\n'),_('Lista do Placar\n')][self.placar is not None])
				obj=NVDAObjects.IAccessible.getNVDAObjectFromEvent(h,-4,0)
				api.setFocusObject(obj)
				obj.setFocus()
				if self.placar is not None:
					# anuncia a lista que compe o placar.
					self.anunciarListaPlacar()
					self.placar=None
				else:
					speech.speakObjectProperties (obj, name=True, role=True)
			elif hVoltarPlacar:
				# tela do placar, obtm a lista com jogadores, rodadas e pontuao.
				sleep(0.2)
				text=api.getForegroundObject().firstChild.displayText
				pattern=re.compile('\d+ \d+ \D+ [1-5]?5?0+')
				self.placar=re.findall(pattern, text)
				# voltando ao menu inicial, acionando o boto voltar.
				obj=NVDAObjects.IAccessible.getNVDAObjectFromEvent(hVoltarPlacar,-4,0)
				clickButton (obj.location)
			return
		elif obj.windowControlID==2 and obj.displayText=='':
			# renomeando o controle de pular vdio da segunda tela.
			obj.name=_('pular video')
			obj.role=controlTypes.ROLE_BUTTON
		elif obj.windowControlID==107 and self.pergunta=='':
			self.pergunta=api.getForegroundObject().firstChild.obterPergunta()
			ui.message(self.pergunta + '\n')
		if obj.windowControlID in range(104,108):
			nome=obj.displayText
			obj.name='%s. %s' %(108-obj.windowControlID,nome)
			self.palavraSoletra=nome
			ui.message ('%s. %s' %(108-obj.windowControlID,obj.displayText))
			return
		nextHandler()
	def anunciarListaPlacar (self):
		# anuncia a lista do placar.
		if len(self.placar)==0:
			ui.message(_('A lista do placar esta vazia'))
			return
		for item  in self.placar:
			posicao=item.split(' ')[0]
			rodada=item.split(' ')[1]
			nome=item.split(' ')[2]
			valor=item.split(' ')[3]
			if int(valor)==1000000:
				valor=_('um milhao de ')
			ui.message (_('%s#. %s, em %s rodadas, ganhou %s reais.') %(posicao,nome,rodada,valor))

	def isDescendantWindow (self,obj, control):
		try:
			h=obj.windowHandle
			j=windowUtils.findDescendantWindow(h,controlID=control)
			if winUser.isWindowEnabled(j):
				return j
			return 0
		except:
			return 0

	def showDialog(self,chlList, title, labelCaption=_(_('Marque as disciplinas para jogar'))):
		self._checklist = CheckListDialog(gui.mainFrame, chlList,title, labelCaption=labelCaption)
	# monta a a listView.
		self._checklist.montaListview(chlList,0)
		# Exibe a caixa de dilogo se a mesma estiver oculta.
		if not self._checklist.IsShown():
			gui.mainFrame.prePopup()
			self._checklist.Show()
			self._checklist.Centre()
			gui.mainFrame.postPopup()


	def getDisciplines(self):
		# obtm um dicionrio com as  disciplinas com as seguintes informaes:
		# nome.
		# posicionamento na tela.
		# se j foi ou no selecionada.
		# a determinao se est selecionada ou no   feita atravs da cor da fonte de cada disciplina.
		# alterando  para o modo de reviso.
		obj=api.getForegroundObject()
		label=review.nextMode()
		if label:
			pos=api.getReviewPosition().copy()
			pos=pos.copy()
			pos.expand(textInfos.UNIT_LINE)
		else:
			speech.speakMessage(_("No flat review for this object"))
		# posicionando o cursor de reviso no final da janela.
		info=api.getReviewPosition().obj.makeTextInfo(textInfos.POSITION_LAST)
		api.setReviewPosition(info.copy())
		api.setReviewPosition(info)
		info.expand(textInfos.UNIT_WORD)
		# obtendo as matrias, mendo as palavras de trs para frente..
		word = info.text
		while not (api.getNavigatorObject().windowClassName == 'ThunderRT5TextBox'):
			if not 'PERSONALIZADO' in word and   not 'SM2006' in word:
				try:
					self.validatesDiscipline(info, word)
				except:
					pass
			word = self.ObterPalavra(info)
		# saindo do modo de reviso.
		label=review.nextMode(prev=True)
		if label:
			pos=api.getReviewPosition().copy()
			pos.expand(textInfos.UNIT_LINE)

	def ObterPalavra (self, info,direcao=False):
		# posiciona o cursor de reviso na palavra anterior ou prxima, retornando-a.
		info.expand(textInfos.UNIT_WORD)
		info.collapse()
		res=1
		if not direcao:
			# move para a palavra anterior.
			res=info.move(textInfos.UNIT_WORD,-1)
		else:
			# move para a prxima palavra.
			res=info.move(textInfos.UNIT_WORD,1)
		api.setReviewPosition(info.copy())
		info.expand(textInfos.UNIT_WORD)
		if res==0:
			return None 
		else:
			api.setReviewPosition(info)
		info.expand(textInfos.UNIT_WORD)
		return info.text

	def validatesDiscipline (self, info, name ):
		# retorna um dicionrio com o nome da disciplina, sua posio na tela e um valor booleano indicando se j foi o uno selecionada.
		color=self.obterCorPrimeiroPlanoText(info)
		obj=api.getNavigatorObject() 
		try:
			p=api.getReviewPosition().pointAtStart
		except (NotImplementedError, LookupError):
			p=None
		if p:
			x=p.x
			y=p.y
			name=name.strip()
			if color == 109: # j foi selecionada.
				self._materias[name]=[x, y, True]
			elif not self._materias.has_key(name):
				self._materias[name]=[x, y, False]


	def obterCorPrimeiroPlanoText (self, info):
		# retorna a cor de primeiro plano de uma palavra selecionada com o cursor de reviso.
		fields=info.getTextWithFields()
		return fields[0].field['color'][2]

	def script_fechar (self, gesture):
		if os.system('"taskkill /im smg6.exe /f /t"'):
			if os.system('"tskill smg6 /a"'):
				return
		winsound.PlaySound('%s\\Audios\\tchau.wav' %_basePath,0)

	def script_enter (self,gesture):
		# abre a caixa de dilogo de seleo de matrias.
		if not isDescendantWindow (api.getForegroundObject(),33):
			gesture.send()
			return
		jogadores=[]
		for x in range(26,34):
			obj=NVDAObjects.IAccessible.getNVDAObjectFromEvent(isDescendantWindow(api.getForegroundObject(), x), -4, 0)
			if obj.value!='':
				jogadores.append(obj.value + ' ')
		if not len(jogadores):
			ui.message (_('Entre com pelo menos um nome de um jogador para continuar'))
			return
		self._materias.clear()
		# obtm a lista de disciplinas visveis na tela com seus respectivos status.
		self.getDisciplines()
		#chama funo responsvel pela exibio da caixa de dilogo para escolha das disciplinas.
		self.showDialog (self._materias, _('Escolha das disciplinas'))

	def obterJogador_valor (self):
		# registra o jogador atual e o valor at o momento obtido assim que a janela de perguntas e respostas recebe foco.
		obj=api.getForegroundObject()
		label=review.nextMode()
		if label:
			pos=api.getReviewPosition().copy()
			pos=pos.copy()
			pos.expand(textInfos.UNIT_LINE)
		else:
			speech.speakMessage(_("No flat review for this object"))
		# posicionando o cursor de reviso no incio  da janela.
		info=api.getReviewPosition().obj.makeTextInfo(textInfos.POSITION_FIRST)
		api.setReviewPosition(info.copy())
		api.setReviewPosition(info)
		info.expand(textInfos.UNIT_WORD)
		while not '\n' in info.text:
			fields=info.getTextWithFields()
			# pegando as cores da palavra selecionada, a do jogador atual pisca em amarelo.
			r=fields[0].field['color'][0]
			g=fields[0].field['color'][1]
			b=fields[0].field['color'][2]
			if r==255 and g==255 and b==0:
				text=api.getForegroundObject().firstChild.displayText.split('\n')[0]
				pat=re.compile(info.text + ' ?- [1-5]?0+')
				l=re.findall(pat,text)
				self.player=(l[0]).split(' - ')[0]
				self.valor=((l[0]).split(' - ')[1])
				globalVars.smg6Valor = int(self.valor)
				break
			self.ObterPalavra(info,True)
		#retornando para o modo objeto
		label=review.nextMode(prev=True)
		if label:
			pos=api.getReviewPosition().copy()
			pos.expand(textInfos.UNIT_LINE)

	__gestures = {
		"kb:tab": "tab",
		"kb:shift+tab": "tab",
		"kb:alt+f4":"fechar",
		"kb:control+enter":"enter",
		"kb:f1":"ajuda",
		"kb:f2":"pergunta",
		"kb:f3":"palavraPergunta",
		"kb:f4":"soletra",
		"kb:f5":"audioPergunta",
		"kb:nvda+h":"atalhos",
		"kb:c":"cartas",
		"kb:j":"jogadorAtual",
		"kb:k":"parar",
		"kb:l":"pular",
		"kb:p":"placas",
		"kb:u":"universitarios",
		}

class CheckListDialog(wx.Dialog):
	def __init__(self, parent, disciplines_list, title, labelCaption = _('Marque as disciplinas para jogar')):
		self.disciplines_list = disciplines_list
		self.disciplines_listCopy = self.disciplines_list.copy ()

		super(CheckListDialog, self).__init__(parent, title=title)

		# Criando a tela.
		mainSizer = wx.BoxSizer(wx.VERTICAL)
		tasksSizer = wx.BoxSizer(wx.VERTICAL)
		tasksLabel = wx.StaticText(self, -1, label=labelCaption)
		tasksSizer.Add(tasksLabel)
		self.listBox = wx.ListCtrl(self, size=(550, 250),style=wx.LC_REPORT|wx.BORDER_SUNKEN)
		tasksSizer.Add(self.listBox, proportion=8)
		#mainSizer.Add(tasksSizer)
		buttonsSizer = wx.BoxSizer(wx.HORIZONTAL)
		checkAllButtonId =wx.NewId()
		self.checkAllButton = wx.Button(self, checkAllButtonId, "&Marcar todas")
		buttonsSizer.Add(self.checkAllButton)
		unCheckAllButtonId =wx.NewId()
		self.unCheckAllButton = wx.Button(self, unCheckAllButtonId, "&Desmarcar todas")
		buttonsSizer.Add(self.unCheckAllButton)
		playButtonId =wx.NewId()
		self.playButton = wx.Button(self, playButtonId, "&Jogar")
		buttonsSizer.Add(self.playButton)
		cancelButton = wx.Button(self, wx.ID_CANCEL)
		buttonsSizer.Add(cancelButton)
		tasksSizer.Add(buttonsSizer)
		mainSizer.Add(tasksSizer)
		# eventos.
		self.Bind(wx.EVT_BUTTON,self.onOk,id=playButtonId)
		self.Bind(wx.EVT_BUTTON,self.onCancel,id=wx.ID_CANCEL)
		self.Bind(wx.EVT_BUTTON,self.onCheckAll,id=checkAllButtonId)
		self.Bind(wx.EVT_BUTTON,self.onUnCheckAll,id=unCheckAllButtonId)
		self.listBox.Bind(wx.EVT_KEY_DOWN, self.onKeyPress)
		wx.EVT_KILL_FOCUS (		self.listBox,self.onLostFocus)
		wx.EVT_KILL_FOCUS (self.checkAllButton,self.onLostFocus)
		wx.EVT_KILL_FOCUS (self.unCheckAllButton,self.onLostFocus)
		wx.EVT_KILL_FOCUS (self.playButton,self.onLostFocus)
		wx.EVT_KILL_FOCUS (cancelButton,self.onLostFocus)
		self.listBox.SetFocus()
		mainSizer.Fit(self)
		self.SetSizer(mainSizer)
	def onLostFocus(self,evt):
		# fecha a caixa de dilogo caso ela venha a perder ofoco.
		obj = api.getForegroundObject()
		hasFocus= False
		for child in obj.children:
			hasFocus+= child.hasFocus
		if not hasFocus:
			self.Hide()
			evt.Skip()


	def onCheckAll(self, evt):
		for key in self.disciplines_list:
			x=self.disciplines_list[key][0]
			y=self.disciplines_list[key][1]
			self.disciplines_list[key]=[x,y,True]
		self.montaListview(self.disciplines_list,0)
		self.listBox.SetFocus()
		evt.Skip()

	def onUnCheckAll(self, evt):
		h=ctypes.windll.user32.FindWindowExA (0,0,'ThunderRT5Form', None)
		if h:
			obj=NVDAObjects.IAccessible.getNVDAObjectFromEvent(h,-4,0)
			obj=obj.firstChild.children[3].children[23]
		for key in self.disciplines_list:
			x=self.disciplines_list[key][0]
			y=self.disciplines_list[key][1]
			self.disciplines_list[key]=[x,y,False]
		self.montaListview(self.disciplines_list,0)
		self.listBox.SetFocus()
		evt.Skip()

	def onCancel(self,evt):
		self.Hide()
		evt.Skip()
		self.Destroy()
		self.disciplines_list={}


	def onOk (self, evt):
		self.Hide()
		evt.Skip()
		sleep(1)
		h=ctypes.windll.user32.FindWindowExA (0,0,'ThunderRT5Form', None)
		if h:
			obj=NVDAObjects.IAccessible.getNVDAObjectFromEvent(h,-4,0)
			obj=obj.firstChild.children[3]
		# checkBox itens
		for item in self.disciplines_list.keys():
			x=self.disciplines_list[item][0]+23 * (not 'port' in item.lower())
			y=self.disciplines_list[item][1]+9 *  (not 'port' in item.lower())

			status = self.disciplines_list[item][2]
			if status != self.disciplines_listCopy[item][2]:
				winUser.setCursorPos (x,y)
				winUser.mouse_event(winUser.MOUSEEVENTF_LEFTDOWN,0,0,None,None)
				winUser.mouse_event (winUser.MOUSEEVENTF_LEFTUP,0,0,None,None)
				sleep (0.05)
				if status:
					clickButton(obj.children[20].location)
				else:
					clickButton(obj.children[17].location)	
		playButton=obj.children[23]
		sleep(0.1)
		if winUser.isWindowEnabled(playButton.windowHandle) and winUser.isWindowVisible(playButton.windowHandle):
			clickButton(playButton.location)
		else:
			pass



	def onKeyPress(self, event):
		keycode = event.GetKeyCode()
		if keycode==wx.WXK_RETURN:
			if self.disciplines_list==self.disciplines_listCopy:
				return
			SendEvent(self.playButton,wx.EVT_BUTTON)
		elif  keycode == wx.WXK_SPACE:
			index=self.listBox.GetFocusedItem()
			disc = self.listBox.GetItemText(index)
			x = self.disciplines_list[disc][0]
			y = self.disciplines_list[disc][1]
			status = self.disciplines_list[disc][2]
			self.disciplines_list[disc]=[x,y, not status]
			self.montaListview(self.disciplines_list,index)
		event.Skip()



	def montaListview(self, disciplines_list, index=0):
		self.listBox.ClearAll()
		self.listBox.InsertColumn(0, _('Disciplina'))
		self.listBox.InsertColumn(1, _('Status'))
		op=[_("not Checked"),_("Checked")]
		itemsChecked = False
		totalCheckeds =0
		for x in self.disciplines_list:
			self.listBox.Append ([x, op[self.disciplines_list[x][2]==True]])
			if self.disciplines_list[x][2]==True:
				itemsChecked = True
				totalCheckeds+=1

		self.unCheckAllButton.Enable(itemsChecked)
		self.playButton.Enable(itemsChecked)
		self.checkAllButton.Enable(totalCheckeds!=len(self.disciplines_list))
		self.listBox.Focus(index)
		self.listBox.Select(index)


class infoDialog(wx.Dialog):
	def __init__(self, parent, title, value):
		self.value = value
		self.title=title
		super(infoDialog, self).__init__(parent, title=title)
		# Create interface
		mainSizer = wx.BoxSizer(wx.VERTICAL)
		tasksSizer = wx.BoxSizer(wx.VERTICAL)
		# Create a ReadOnly editable text.
		read_only_txtCtrlId =120#wx.NewId()
		self.read_only_txtCtrl = wx.TextCtrl(self,read_only_txtCtrlId,self.value,style=wx.TE_MULTILINE|wx.TE_READONLY, size=(800,200))
		tasksSizer.Add(self.read_only_txtCtrl)
		mainSizer.Add(tasksSizer)
		# Create buttons.
		buttonsSizer = wx.BoxSizer(wx.HORIZONTAL)
		self.closeButton = wx.Button(self,wx.ID_CANCEL ,'&Fechar' )
		buttonsSizer.Add(self.closeButton)
		# TextCtrl and buttons events.
		wx.EVT_KILL_FOCUS (self.read_only_txtCtrl,self.onLostFocus)
		wx.EVT_KILL_FOCUS (self.closeButton,self.onLostFocus)
		tasksSizer.Add(buttonsSizer)
		mainSizer.Add(tasksSizer)
		mainSizer.Fit(self)
		self.SetSizer(mainSizer)
		self.read_only_txtCtrl.SetInsertionPoint(0)
		self.read_only_txtCtrl.SetFocus()

	def onLostFocus(self,evt):
		# fecha a caixa de dilogo caso ela venha a perder ofoco.
		obj = api.getForegroundObject()
		hasFocus= False
		for child in obj.children:
			hasFocus+= child.hasFocus
		if not hasFocus:
			self.Hide()
			evt.Skip()

#ThunderRT5Form

